#include <iostream>
#include <vector>
#include <algorithm> 

struct Trkac {
    int x; // pocetna pozicija
    int v; // brzina
};

// Funkcija koja pronalazi trenutak K-tog preticanja
double vreme_preticanja(const std::vector<Trkac>& trkaci, int K) {
    std::vector<double> trenuci_preticanja;

    for (int i = 0; i < trkaci.size(); ++i) {
        for (int j = i + 1; j < trkaci.size(); ++j) {
            if (trkaci[i].v > trkaci[j].v) {
                double trenutni_trenutak = static_cast<double>(trkaci[j].x - trkaci[i].x) / (trkaci[i].v - trkaci[j].v);
                trenuci_preticanja.push_back(trenutni_trenutak);
            }
        }
    }

    // Sortiranje trenutke preticanja
    std::sort(trenuci_preticanja.begin(), trenuci_preticanja.end());

    // Vracanje K-tog trenutka preticanja
    return trenuci_preticanja[K - 1];
}

int main() {
    int N, K;
    std::cin >> N >> K;

    // Ucitavanje informacije o trkacima
    std::vector<Trkac> trkaci(N);
    for (int i = 0; i < N; ++i) {
        std::cin >> trkaci[i].x >> trkaci[i].v;
    }

    // Pronalazenje i ispisivanje trenutka K-tog preticanja
    double rezultat = vreme_preticanja(trkaci, K);
    std::cout << rezultat << std::endl;

    return 0;
}